/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'wake_up_new_task' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process forks, child must be tracked as well! We need to update RB tree.
 *
 * Caveats:
 *  - Previous version was hooking 'do_fork' function.
 *
 * Timeline:
 *  - Created: 18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"

static int p_wake_up_new_task_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct task_struct *p_task = (struct task_struct *)p_regs_get_arg1(p_regs);

   if (p_is_ed_task(p_task))
      p_dump_task_f(p_task);

   p_ed_enforce_validation();

   return 0;
}

static struct lkrg_probe p_wake_up_new_task_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "wake_up_new_task",
    .kp.pre_handler = p_wake_up_new_task_entry,
  }
};

GENERATE_INSTALL_FUNC(wake_up_new_task)
