/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept ptrace syscall
 *
 * Notes:
 *  - Enforce Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 5.XI.2020
 *
 * Author:
 * - Mariusz Zaborski (https://oshogbo.vexillium.org/)
 *
 */

#include "../../../../p_lkrg_main.h"

static int p_security_ptrace_access_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   if ((p_tmp = ed_task_lock_current())) {
      // This process is on the ED list - validate 'off' flag
      p_ed_validate_off_flag_wrap(p_tmp);
      ed_task_unlock(p_tmp);
   }

   p_ed_enforce_validation();

   return 0;
}

static struct lkrg_probe p_security_ptrace_access_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "security_ptrace_access_check",
    .kp.pre_handler = p_security_ptrace_access_entry,
  }
};

GENERATE_INSTALL_FUNC(security_ptrace_access)
