/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '__scm_send' function
 *
 * Notes:
 *  - This hook enforces process validation
 *    before SCM_CREDENTIALS is used (for UNIX sockets).
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 28.IV.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"

static int p_scm_send_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   p_ed_enforce_validation();

   return 0;
}

static struct lkrg_probe p_scm_send_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "__scm_send",
    .kp.pre_handler = p_scm_send_entry,
  }
};

GENERATE_INSTALL_FUNC(scm_send)
