/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Generic install and uninstall functions
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 4.V.2020
 *
 * Author:
 *  - Mariusz Zaborski (https://oshogbo.vexillium.org/)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_INSTALL_H
#define P_LKRG_EXPLOIT_DETECTION_INSTALL_H

struct lkrg_probe {
   enum { LKRG_PROBE_OFF, LKRG_PROBE_ON, LKRG_PROBE_ISRA } state;
   enum { LKRG_KPROBE, LKRG_KRETPROBE } type;
   struct kretprobe krp;
};

int p_get_kprobe_maxactive(void);

int p_install_hook(struct lkrg_probe *probe, int p_isra);
void p_uninstall_hook(struct lkrg_probe *probe);

#define GENERATE_INSTALL_FUNC(name)                                                       \
   int p_install_##name##_hook(int p_isra) {                                              \
      return p_install_hook(&p_##name##_probe, p_isra);                                   \
   }                                                                                      \
                                                                                          \
   void p_uninstall_##name##_hook(void) {                                                 \
      return p_uninstall_hook(&p_##name##_probe);                                         \
   }

#define GENERATE_INSTALL_FUNC_PROTO(name) \
   extern int p_install_##name##_hook(int p_isra); \
   extern void p_uninstall_##name##_hook(void);

#endif
