/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept exit syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process dies/exists we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"

static int p_do_exit_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {
   p_debug_kprobe_log(
          "p_do_exit_entry: comm[%s] Pid:%d",current->comm,current->pid);

//   p_ed_enforce_validation();

   if (ed_task_del_current()) {
      /*
       * This can happen if p_is_ed_task() was 0 at the time this new task
       * woke up (which isn't necessarily the case now since UMH kthreads
       * gain mm during their lifetime) or if our memory allocation for the
       * task had failed.  So this condition here isn't necessarily an error.
       */
      ;// DEBUG: p_debug_log(P_LOG_DEBUG, "Can't remove pid %u, name %s", task_pid_nr(current), current->comm);
   }

   /* A dump_stack() here will give a stack backtrace */
   return 0;
}

static struct lkrg_probe p_do_exit_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "do_exit",
    .kp.pre_handler = p_do_exit_entry,
  }
};

GENERATE_INSTALL_FUNC(do_exit)
