/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'capable' function
 *
 * Notes:
 *  - Enforce Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 22.III.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"

static int p_capable_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp = NULL;

   p_ed_pcfi_cpu(1);

//   p_ed_enforce_validation();

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         p_ed_enforce_pcfi(NULL, p_tmp, p_regs);
         p_ed_validate_current(p_tmp);
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_capable_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "security_capable",
    .kp.pre_handler = p_capable_entry,
  }
};

GENERATE_INSTALL_FUNC(capable)
