/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept *call_usermodehelper_exec* function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When kernel calls user-mode helper, we need to verify task's integrity
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 01.IV.2019
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"

static int p_call_usermodehelper_exec_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   p_ed_pcfi_cpu(1);

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         p_ed_validate_current(p_tmp);
         p_ed_enforce_pcfi(NULL, p_tmp, p_regs);
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_call_usermodehelper_exec_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "call_usermodehelper_exec",
    .kp.pre_handler = p_call_usermodehelper_exec_entry,
  }
};

GENERATE_INSTALL_FUNC(call_usermodehelper_exec)
