/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '__mark_inode_dirty' function
 *
 * Notes:
 *  - Enforce Exploit Detection CFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

static int p_pcfi_mark_inode_dirty_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   p_ed_pcfi_cpu(1);

//   p_ed_enforce_validation();

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         if (p_ed_enforce_pcfi(NULL, p_tmp, p_regs)) {
            struct inode *p_inode = (struct inode *)p_regs_get_arg1(p_regs);
            p_print_log(P_LOG_ALERT, "BLOCK: Task: Changing inode %lu's mode from 0%o to 0 and uid/gid to 65534",
               p_inode->i_ino, p_inode->i_mode);

            p_set_uid(&p_inode->i_uid, 65534);
            p_set_gid(&p_inode->i_gid, 65534);
//            p_inode->i_mode = 0;
            p_inode->i_mode = 0 | S_IFREG;
         }
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_pcfi_mark_inode_dirty_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "__mark_inode_dirty",
    .kp.pre_handler = p_pcfi_mark_inode_dirty_entry,
  }
};

GENERATE_INSTALL_FUNC(pcfi_mark_inode_dirty)
