/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'lookup_fast' function
 *
 * Notes:
 *  - Enforce Exploit Detection CFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

static int p_pcfi_lookup_fast_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   p_ed_pcfi_cpu(1);

//   p_ed_enforce_validation();

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         if (p_ed_pcfi_validate_sp(NULL, p_tmp, p_regs_get_sp(p_regs))) {
            // kill this process!
            p_pcfi_kill_ed_task(p_tmp);
         }
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_pcfi_lookup_fast_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "lookup_fast",
    .kp.pre_handler = p_pcfi_lookup_fast_entry,
  }
};

GENERATE_INSTALL_FUNC(pcfi_lookup_fast)
