/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '____queue_work' function
 *
 * Notes:
 *  - Enforce Exploit Detection CFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

static int p_pcfi___queue_work_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   p_ed_pcfi_cpu(0);

   if (!in_irq() && p_is_ed_task(current)) {
      /* Do not take ED lock */
      if ((p_tmp = ed_task_trylock_current())) {
         p_ed_validate_current(p_tmp);
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_pcfi___queue_work_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "__queue_work",
    .kp.pre_handler = p_pcfi___queue_work_entry,
  }
};

GENERATE_INSTALL_FUNC(pcfi___queue_work)
