/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'revert_creds' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'rever_creds', we need to correctly handle this situation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 10.X.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

#if LINUX_VERSION_CODE < KERNEL_VERSION(6,13,0)

static notrace int p_revert_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

#ifdef P_LKRG_TASK_OFF_DEBUG
   struct p_ed_process *p_tmp;

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         p_debug_off_flag_override_on(p_tmp, 32, p_regs);
         ed_task_unlock(p_tmp);
      }
   }
#endif
   return 0;
}

static notrace int p_revert_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         p_set_ed_process_override_on(p_tmp);
         p_ed_enforce_pcfi(NULL, p_tmp, p_regs);
         p_ed_validate_current(p_tmp);
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_revert_creds_probe = {
  .type = LKRG_KRETPROBE,
  .krp = {
    .kp.symbol_name = "revert_creds",
    .handler = p_revert_creds_ret,
    .entry_handler = p_revert_creds_entry,
  }
};

GENERATE_INSTALL_FUNC(revert_creds)

#endif
