/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'override_creds' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'override_creds', we need to correctly 'propagate'
 *    this information.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 10.X.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

#if LINUX_VERSION_CODE < KERNEL_VERSION(6,13,0)

static notrace int p_override_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         p_ed_validate_current(p_tmp);
#ifdef P_LKRG_TASK_OFF_DEBUG
         p_debug_off_flag_override_off(p_tmp, 31, p_regs);
#endif
         /*
          * Set temporary 'disable' flag:
          *  - It is possible that this flag is already set. This is not a problem because in
          *    normal scenario task that ends up being here must call 'revert_creds' before
          *    switching to user-mode. This will 'normalize' this flag to the correct state.
          */
         p_set_ed_process_override_off(p_tmp);
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static notrace int p_override_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         p_ed_enforce_pcfi(NULL, p_tmp, p_regs);
         ed_task_unlock(p_tmp);
      }
   }

   return 0;
}

static struct lkrg_probe p_override_creds_probe = {
  .type = LKRG_KRETPROBE,
  .krp = {
    .kp.symbol_name = "override_creds",
    .handler = p_override_creds_ret,
    .entry_handler = p_override_creds_entry,
  }
};

GENERATE_INSTALL_FUNC(override_creds)

#endif
