/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'ovl_dentry_is_whiteout' function which is called by
 *    'ovl_create_or_link'.
 *
 * Notes:
 *  - Some code paths in OverlayFS call override_creds() twice yet later call
 *    revert_creds() only once.  We need to correctly handle this situation and
 *    adjust 'off' flag.
 *
 * Caveats:
 *  - Originally, 'ovl_create_or_link' function was hooked.
 *    Due the fact it is declared with 'static' keyword, it may be inlined.
 *
 * Timeline:
 *  - Modified: 27.VII.2022
 *  - Created:  28.III.2019
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_OVL_OVERRIDE_SYNC_H
#define P_LKRG_EXPLOIT_DETECTION_OVL_OVERRIDE_SYNC_H

#if LINUX_VERSION_CODE >= KERNEL_VERSION(6, 13, 0)
/*
 * We can't/don't hook override/revert_creds() on 6.13+, so we also don't need
 * to hook anything OverlayFS on those kernels.
 */
#define P_OVL_OVERRIDE_SYNC_MODE 0
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(6, 10, 0)
/*
 * 6.10 introduces ovl_tmpfile() which we need to cover, but it doesn't use
 * ovl_dentry_is_whiteout(). Probe ovl_dentry_init_reval() instead.
 */
#define P_OVL_OVERRIDE_SYNC_MODE 2
#define P_OVL_OVERRIDE_SYNC_FUNC "ovl_dentry_init_reval"
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(4, 10, 0) || \
    (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 4, 179) && LINUX_VERSION_CODE < KERNEL_VERSION(4, 5, 0)) || \
    (defined(RHEL_RELEASE_CODE) && RHEL_RELEASE_CODE > RHEL_RELEASE_VERSION(7, 4))
#define P_OVL_OVERRIDE_SYNC_MODE 2
#define P_OVL_OVERRIDE_SYNC_FUNC "ovl_dentry_is_whiteout"
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(4, 7, 0)
/* Between 4.7 and 4.9, the 'ovl_dentry_is_whiteout' function does not exist */
#define P_OVL_OVERRIDE_SYNC_MODE 1
#define P_OVL_OVERRIDE_SYNC_FUNC "ovl_create_or_link"
#else
#define P_OVL_OVERRIDE_SYNC_MODE 0
#endif

#if P_OVL_OVERRIDE_SYNC_MODE

extern struct lkrg_probe p_ovl_override_sync_probe;

GENERATE_INSTALL_FUNC_PROTO(ovl_override_sync)
void p_reinit_ovl_override_sync_kretprobe(void);

#endif
#endif
