/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'ovl_dentry_is_whiteout' function which is called by
 *    'ovl_create_or_link'.
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'ovl_create_or_link', we need to correctly handle
 *    this situation and adjust 'off' flag
 *
 * Caveats:
 *  - Originally, 'ovl_create_or_link' function was hooked.
 *    Due the fact it is declared with 'static' keyword, it may be inlined.
 *
 * Timeline:
 *  - Modified: 27.VII.2022
 *  - Created:  28.III.2019
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../../p_lkrg_main.h"

#if P_OVL_OVERRIDE_SYNC_MODE

static int p_ovl_override_sync_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   return 0;
}

static notrace int p_ovl_override_sync_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   if (p_is_ed_task(current)) {
      if ((p_tmp = ed_task_lock_current())) {
         if (p_verify_ovl_override_sync(p_tmp)) {
#ifdef P_LKRG_TASK_OFF_DEBUG
            p_debug_off_flag_override_on(p_tmp, 30, p_regs);
#endif
            p_set_ed_process_override_on(p_tmp);
         }
         p_ed_validate_current(p_tmp);
         p_ed_enforce_pcfi(NULL, p_tmp, p_regs);
         ed_task_unlock(p_tmp);
      } else {
         p_ed_enforce_pcfi(current, NULL, p_regs);
      }
   }

   return 0;
}

void p_reinit_ovl_override_sync_kretprobe(void) {

   memset(&p_ovl_override_sync_probe.krp, 0, sizeof(p_ovl_override_sync_probe.krp));
   p_ovl_override_sync_probe.krp.kp.symbol_name = P_OVL_OVERRIDE_SYNC_FUNC;
   p_ovl_override_sync_probe.krp.handler = p_ovl_override_sync_ret;
   p_ovl_override_sync_probe.krp.entry_handler = p_ovl_override_sync_entry;
   p_ovl_override_sync_probe.krp.maxactive = p_get_kprobe_maxactive();
}

struct lkrg_probe p_ovl_override_sync_probe = {
  .type = LKRG_KRETPROBE,
  .krp = {
    .kp.symbol_name = P_OVL_OVERRIDE_SYNC_FUNC,
    .handler = p_ovl_override_sync_ret,
    .entry_handler = p_ovl_override_sync_entry,
  }
};

GENERATE_INSTALL_FUNC(ovl_override_sync)

#endif
