/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'search_binary_handler' syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls execve, we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - 18.I.2021:   Replace one 'search_binary_handler' hook with two
 *                 independent one to reduce the race window while
 *                 the process is not being verified
 *  - 28.XII.2020: Replace various execve syscall hooks with one hook
 *                 of the function 'search_binary_handler'
 *  - Created:     18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

static LKRG_DEBUG_TRACE int p_security_bprm_committing_creds_entry(struct kprobe *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;

   p_ed_enforce_validation();
   if ((p_tmp = ed_task_lock_current())) {
      p_verify_addr_limit(p_tmp);
#ifdef P_LKRG_TASK_OFF_DEBUG
      p_debug_off_flag_off(p_tmp, 39);
#endif
      // This process is on the ED list - set temporary 'disable' flag!
      p_set_ed_process_off(p_tmp);
      ed_task_unlock(p_tmp);
   }

   return 0;
}

static struct lkrg_probe p_security_bprm_committing_creds_probe = {
  .type = LKRG_KPROBE,
  .krp = {
    .kp.symbol_name = "security_bprm_committing_creds",
    .kp.pre_handler = p_security_bprm_committing_creds_entry,
  }
};

GENERATE_INSTALL_FUNC(security_bprm_committing_creds)
