/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'search_binary_handler' syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls execve, we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - 18.I.2021:   Replace one 'search_binary_handler' hook with two
 *                 independent one to reduce the race window while
 *                 the process is not being verified
 *  - 28.XII.2020: Replace various execve syscall hooks with one hook
 *                 of the function 'search_binary_handler'
 *  - Created:     18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

static LKRG_DEBUG_TRACE int p_security_bprm_committed_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   if ((p_tmp = ed_task_lock_current())) {
      // This process is on the ED list - update information!
      p_update_ed_process(p_tmp, 1);
#ifdef P_LKRG_TASK_OFF_DEBUG
      p_debug_off_flag_reset(p_tmp, 40);
#endif
      p_set_ed_process_on(p_tmp);
      ed_task_unlock(p_tmp);
   }

//   p_ed_enforce_validation();

   return 0;
}

static struct lkrg_probe p_security_bprm_committed_creds_probe = {
  .type = LKRG_KRETPROBE,
  .krp = {
    .kp.symbol_name = "security_bprm_committed_creds",
    .handler = p_security_bprm_committed_creds_ret,
    .entry_handler = NULL,
  }
};

GENERATE_INSTALL_FUNC(security_bprm_committed_creds)
