#!/bin/sh

# Simple Logger with parcing for Platform Event Traps from Intel AMT devices
#
# Ver. 1.4
# -----------------------------------------------------------------------
#   Copyright 2012 Stanislav V. Zankov
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# -----------------------------------------------------------------------
#
# To use with the Net-SNMP package add to /etc/snmp/snmptrapd.conf:
#   traphandle .iso.3.6.1.4.1.3183.*  /usr/share/amttool-tng/amt_traps.sh &>/dev/null
#

LOG_PATH=/var/log/amt

LOG=$LOG_PATH/amt_log.txt
#LOG=/dev/null

LOG_RAW=$LOG_PATH/amt_log.raw
LOG_RAW=/dev/null

LOG_FULL=$LOG_PATH/amt_log_full.txt
#LOG_FULL=/dev/null

AMTTOOL=/usr/bin/amttool

EMAIL=
SYSLOG_PRI=user.notice

IGNORE_LAN_CONNECTED=1

PATH=/sbin:/usr/sbin:/bin:/usr/bin

#-----------------------------------------------------------------------

readonly -A SEV_NAMES=(
	["00"]="Unspecified"
	["01"]="Monitor"
	["02"]="Information"
	["04"]="OK now"
	["08"]="Warning"
	["10"]="Critical"
	["20"]="Non-recoverable" )

read ws_name
read conn_details

echo -e  "$( date +%Y-%m-%d\ %T )\t${ws_name}\t$conn_details" >> $LOG_RAW

PET=$(
D=0
while read str data
do
    echo " ${str} ${data}" >> $LOG_RAW

    if [ $str = "iso.3.6.1.6.3.1.1.4.1.0" -a "1${data%.*}" = "1iso.3.6.1.4.1.3183.1.1.0" ]
    then
	echo -n "${data##*.}_"
    fi
    if [ $D -gt 0  -a  $D -le 2 ]; then
	echo -n "${str} ${data} " |tr -d \"
	D=$(( $D+1 ))
    fi
    if [ $str = "iso.3.6.1.4.1.3183.1.1.1" ]; then
	echo -n "${data} " |tr -d \"
	D=1
    fi
done )

PET0=$( echo "obase=16;ibase=10;${PET%_*}" | bc )
PET1=${PET#*_}

if [ $IGNORE_LAN_CONNECTED -ne 0  -a  $PET0 = "270A03" ]; then
    exit 0
fi

P0=$( echo $PET0 | \
    sed -e 's/\([[:xdigit:]]\{2\}\)$/ eo:\1h/;s/\([[:xdigit:]]\{2\}\) / et:\1h /;s/^\([[:xdigit:]]\{1,2\}\) /est:\1h /;s/:0/:/g'
)
P1=$( echo "d:${PET1:93:23}" | sed -e 's/ /h-/g;s/$/h/' )
EVNT_DESC=$( $AMTTOOL ws event description_get $P0 $P1 )
SEV_DESC=${SEV_NAMES[${PET1:78:2}]}
TIME_SEC=$( echo "obase=10;ibase=16;${PET1:54:11}" | tr -d \  | bc )
TIME_HUMAN=$(
    date --date "1998-01-01 $TIME_SEC seconds" 2>/dev/null | tr -d '\n'
    echo -n " / "
    date --date '1998-01-01 UTC '$TIME_SEC' seconds' 2>/dev/null
)
if [ $? -ne 0 ]; then
    TIME_HUMAN=$(
	date --date "1970-01-01 $TIME_SEC seconds" 2>/dev/null | tr -d '\n'
	echo -n " / "
	date --date '1970-01-01 UTC '$TIME_SEC' seconds' 2>/dev/null
    )
fi


if [ -n $EMAIL ]; then
    echo -e "$ws_name\n$EVNT_DESC\nSeverity: $SEV_DESC" | \
	mail -s "[iAMT event] $ws_name :: $SEV_DESC :: $EVNT_DESC" $EMAIL
fi

if [ -n $SYSLOG_PRI ]; then
	logger -t iAmt_event -p $SYSLOG_PRI "$ws_name, sev.:$SEV_DESC, $EVNT_DESC"
fi


( echo -en "$( date +%Y-%m-%d\ %T )\t${ws_name}\tSeverity: $SEV_DESC\t"
echo "$EVNT_DESC"
) >> $LOG


( echo -e  "$( date +%Y-%m-%d\ %T )\t${ws_name}\t$conn_details"
echo    " [$P0] $EVNT_DESC"
echo -e " GUID:      \t${PET1:0:47}"
echo -e " Sequence No:\t${PET1:48:5}"
echo -e " Time:    \t$TIME_SEC seconds / $TIME_HUMAN"
echo -e " UTC Offset:\t${PET1:66:5}"
echo -e " Trap  SrcType:\t${PET1:72:2}"
echo -e " Event SrcType:\t${PET1:75:2}"
echo -e " Event Sever.:\t${PET1:78:2} $SEV_DESC"
echo -e " Sensor Device:\t${PET1:81:2}"
echo -e " Sensor Number:\t${PET1:84:2}"
echo -e " Entity:     \t${PET1:87:2}"
echo -e " Entity Inst.:\t${PET1:90:2}"
echo -e " Event Data:\t${PET1:93:23}"
echo -e " Lang Code: \t${PET1:117:2}"
echo -e " Manufact. ID:\t${PET1:120:11}"
echo -e " System ID: \t${PET1:132:5}"
echo -e " OEM Fields:\t${PET1:138}" ) >> $LOG_FULL

exit 0
